<?php 
/*------------------------------------------------
 * Загрузчик файла YML   		        2019-03-25
 * Copyright © 2020
 * license-server.info 
 *
 * управляющий модуль
 *
 * License: Commercial open source software (COSS) 
 *------------------------------------------------
 */

	// контроль доступа по IP
	$a_allow = false;
	$a_ips = '';
	if (is_file('.allowed_ip')){
		$a_ips = file('.allowed_ip');
	}elseif (is_file('../.allowed_ip')){
		$a_ips = file('../.allowed_ip');
	}
	
	if (is_array($a_ips)){
		foreach ($a_ips as $a_ip){
			$a_ip = trim($a_ip);
			if (strpos($a_ip, '*') !== false){
				
				// process 127.0.*.*
				
				$remote = explode('.', $_SERVER['REMOTE_ADDR']);
				$a = explode('.', $a_ip);
				
				$true_count = 0;
				for ($i=0;$i<4;$i++){
					switch ($i){
						case 0:
						case 1:
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
							break;
						case 2:
						case 3:
							if ($a[$i] == '*'){
								// пропускаем
								$true_count++;
							}else{
								if ($remote[$i] != $a[$i]){
									break 2;
								}else{
									$true_count++;
								}
							}
							
					}
				}
				if ($true_count == 4){
					$a_allow = true;
					break;
				}
				
			}else{
				if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
					$a_allow = true;
					break;
				}
			}
		}
		
	}
	if ($a_allow === false){
		header('Content-Type: text/html; charset=utf-8');
		die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблокирован');
	}
	
	error_reporting (E_ALL);
	date_default_timezone_set ('Europe/Kiev');
	
	if (isset($_GET['mode']) AND $_GET['mode'] == 'show_file'){
		
		if (isset($_GET['cfg'])){
			$cfg_id = $_GET['cfg'];
		}else{
			$cfg_id = '';
		}

		require_once ("oc_loader_yml.cfg$cfg_id.php");		// конфиг-файл
		
		$file = curl_get_contents($site_ssl_select.'://'.$xml_link);
		if ($file == ''){
			header('Content-Type: text/html; charset=UTF-8');
			die("Ошибка: Не удалось скачать файл поставщика по адресу ".$site_ssl_select.'://'.$xml_link);
		}
		
		$data = simplexml_load_string($file);
		
		if ($data === false){
			header('Content-Type: text/html; charset=UTF-8');
			die("Ошибка: не удалось получить данные по ссылке ".$site_ssl_select.'://'.$xml_link." ответ = $file ");
		}
		
		header('Content-Type: text/xml; charset=utf-8');
		echo($file);
		die;
	}
	
	header('Content-Type: text/html; charset=utf-8');
	$title1 = "Загрузчик файла YML";
	$title2 = "Управляющий модуль";
	
	// конфигурации
	$d = dir(".");
	
	$cfg_array = array();
	
	while (false !== ($entry = $d->read())) {
		if ($entry != "."){
			if ($entry != ".."){
				if (strpos($entry, ".cfg") !== false){
					$entry_array = explode('.', $entry);
					$cfg_array[] = str_replace('cfg', '', $entry_array[1]);
				}
			}
		}
	}
	$d->close();

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" >
<title><?php echo $title1; ?></title>
</head>
<body style="font-family:Trebuchet MS; font-size: 10pt;" bgcolor="#FEF4EB">

<table width="100%" bgcolor="#416e98">
<tr valign="middle">
<td><span style="font-size:25px; color:#FFF; font-family:Trebuchet MS"><?php echo $title1; ?></span></td>
<td align="right"><span style="font-size:15px; color:#FFF; font-family:Trebuchet MS"><?php echo $title2; ?></span></td>
</tr>
</table>
<center>
<br/>

<table width="70%">
<?php 
	foreach ($cfg_array as $cfg){
		if ($cfg == ''){
?>
<tr valign="middle">
<td align="center"><a href="setup.php?token=<?php echo time();?>" target="_blank">Настройка</a></td>
</tr>
<?php 
		}else{
?>
<tr valign="middle">
<td align="center"><a href="setup.php?token=<?php echo time();?>&cfg=<?php echo $cfg; ?>" target="_blank">Настройка для <?php echo $cfg; ?></a></td>
</tr>
<?php 
		}
	}
?>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<?php 
	foreach ($cfg_array as $cfg){
		if ($cfg == ''){
?>
<tr valign="middle">
<td align="center"><a href="set_parameters.php?token=<?php echo time();?>" target="_blank">Выбор параметров</a></td>
</tr>
<?php 
		}else{
?>
<tr valign="middle">
<td align="center"><a href="set_parameters.php?token=<?php echo time();?>&cfg=<?php echo $cfg; ?>" target="_blank">Выбор параметров для <?php echo $cfg; ?></a></td>
</tr>
<?php 
		}
	}
?>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<?php 
	foreach ($cfg_array as $cfg){
		if ($cfg == ''){
?>
<tr valign="middle">
<td align="center"><a href="index.php?mode=show_file&token=<?php echo time();?>" target="_blank">Показать файл YML</a></td>
</tr>
<?php 
		}else{
?>
<tr valign="middle">
<td align="center"><a href="index.php?token=<?php echo time();?>&mode=show_file&cfg=<?php echo $cfg; ?>" target="_blank">Показать файл YML для <?php echo $cfg; ?></a></td>
</tr>
<?php 
		}
	}
?>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<?php 
	foreach ($cfg_array as $cfg){
		if ($cfg == ''){
?>
<tr valign="middle">
<td align="center"><a target=_blank href="oc_loader_yml.php?token=<?php echo time();?>&start=now" >Запустить загрузчик</a></td>
</tr>
<?php 
		}else{
?>
<tr valign="middle">
<td align="center"><a target=_blank href="oc_loader_yml.php?token=<?php echo time();?>&start=now&cfg=<?php echo $cfg; ?>" >Запустить загрузчик для <?php echo $cfg; ?></a></td>
</tr>
<?php 
		}
	}
?>
<tr valign="middle">
<td align="center">
<br/>В режиме эксплуатации не рекомендуется запускать загрузчик из браузера
<hr /></td>
</tr>
<tr>
<td align="center"><a href="log/index.php?token=<?php echo time();?>" target="_blank">Отчеты</a></td>
</tr>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<tr valign="middle">
<td align="center"><a target=_blank href="show_license.php?token=<?php echo time();?>">Проверить лицензию</a></td>
</tr>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
<tr valign="middle">
<td align="center"><a target=_blank href="phpinfo.php?token=<?php echo time();?>">Информация о сервере</a></td>
</tr>
<tr valign="middle">
<td align="center"><hr /></td>
</tr>
</table>

</center>
</body>
</html>

<?php 
function curl_get_contents($url, array $get = array(), array $options = array())
{
	
	$defaults = array(
			CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
			CURLOPT_HEADER => 0,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_FOLLOWLOCATION => 1,
			CURLOPT_TIMEOUT => 600,
			CURLOPT_SSL_VERIFYPEER => false
	);
	
	$ch = curl_init();
	curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
	if(!$result = curl_exec($ch)) {
		trigger_error(curl_error($ch));
		$result = 'error: '.curl_error($ch);
	}else{
		//echo 'OK';
	}
	curl_close($ch);
	
	return $result;
}


?>